#ifndef __Reconcile_Impl_hpp__
#define __Reconcile_Impl_hpp__ 1

// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2006-2007 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE: Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

#include "XMP_Environment.h"	// ! This must be the first include.
#include "XMP_Const.h"

// #include "ReconcileLegacy.hpp"
	#ifndef XMP_Throw
		#define XMP_Throw(msg,id)	throw XMP_Error ( id, msg )
	#endif
	#ifndef XMP_Assert
		#define XMP_Assert(exp)		/* nothing */
	#endif
#include "MD5.h"

#include <string>

// =================================================================================================
/// \file Reconcile_Impl.hpp
/// \brief Implementation utilities for the legacy metadata reconciliation support.
///
// =================================================================================================

typedef XMP_Uns8 MD5_Digest[16];	// ! Should be in MD5.h.

namespace ReconcileUtils {
	
	static const char * kHexDigits = "0123456789ABCDEF";
	
	bool IsUTF8       ( const void * _utf8Ptr, size_t utf8Len );
	
	void UTF8ToLocal  ( const void * _utf8Ptr, size_t utf8Len, std::string * local );
	void UTF8ToLatin1 ( const void * _utf8Ptr, size_t utf8Len, std::string * latin1 );
	void LocalToUTF8  ( const void * _localPtr, size_t localLen, std::string * utf8 );
	void Latin1ToUTF8 ( const void * _latin1Ptr, size_t latin1Len, std::string * utf8 );
		// *** These ought to be with the Unicode conversions.

};	// ReconcileUtils

#endif	// __Reconcile_Impl_hpp__
